// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 ViewInv:ViewInverse;
   float4x4 ViewProj:ViewProjection;
   float4x4 View:View;

//-------------
// tweaks
//--------------
   float4 ViewSize1;
   float4 ViewSize2;
   float4 ViewProjInv1;
   float4 ViewProjInv2;
   float4 ViewProjInv3;
   float4 ViewProjInv4;
   float4 LightPosition[30];
   float4 LightSpot[30];
   float4 LightMask[30];
   float4 LightProj1[30];
   float4 LightProj2[30];
   float4 LightProj3[30];
   float4 LightProj4[30];
   float4 ShadowMask[30];

//--------------
// Textures
//--------------
   texture DepthTexture <string Name = " ";>;
   sampler DepthSampler=sampler_state 
      {
	Texture=<DepthTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
	MipFilter=None;
	MinFilter=None;
	MagFilter=None;
      };
   texture LightTexture <string Name = " ";>;
   sampler LightSampler=sampler_state 
      {
	Texture=<LightTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
	MipFilter=None;
      };
   texture ShadowMapTexture <string Name = " ";>;
   sampler ShadowMapSampler=sampler_state 
      {
	Texture=<ShadowMapTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
 	float2 Tex0:TEXCOORD0;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float4 Proj:TEXCOORD0;
 	float4 ClipSpace:TEXCOORD1;
 	float4 LightPos:TEXCOORD2;
 	float4 LightSpot:TEXCOORD3;
	float4 Proj1:TEXCOORD4;
	float4 Proj2:TEXCOORD5;
	float4 Proj3:TEXCOORD6;
	float4 Proj4:TEXCOORD7;
	float4 LightMask:COLOR0;
	float4 ShadowMask:COLOR1;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=mul(IN.Pos,WorldVP); 
        OUT.Proj=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z,OUT.Pos.w);
        OUT.ClipSpace=float4(OUT.Pos.x,-OUT.Pos.y,OUT.Pos.z,OUT.Pos.w);
	int ArrayIdx=floor(IN.Tex0.x);
	OUT.LightPos=LightPosition[ArrayIdx];
	OUT.LightSpot=LightSpot[ArrayIdx];
	OUT.LightMask=LightMask[ArrayIdx];
	OUT.Proj1=LightProj1[ArrayIdx];
	OUT.Proj2=LightProj2[ArrayIdx];
	OUT.Proj3=LightProj3[ArrayIdx];
	OUT.Proj4=LightProj4[ArrayIdx];
	OUT.ShadowMask=ShadowMask[ArrayIdx];
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
     {
	float4x4 ViewProjInv=float4x4(ViewProjInv1,ViewProjInv2,ViewProjInv3,ViewProjInv4);
	float Depth=tex2Dlod(DepthSampler,((IN.Proj/IN.Proj.w)*ViewSize2)+ViewSize1);
	float4 WorldPos=mul(float4(IN.ClipSpace.xy/IN.ClipSpace.w,Depth,1),ViewProjInv);
	float3 LightVec=IN.LightPos.xyz-(WorldPos.xyz/WorldPos.w);
	float Attenuation=length(LightVec);
	float SpotLight=ceil((dot(LightVec/Attenuation,IN.LightSpot.xyz)-IN.LightSpot.w));
	if(Attenuation/IN.LightPos.w>SpotLight) discard;
	float4 LightProj=mul(float4(LightVec,0),float4x4(IN.Proj1,IN.Proj2,IN.Proj3,IN.Proj4));
        LightProj.xy=(LightProj.xy/LightProj.w)*float2(0.5,-0.5)+0.5;
	float SpotImage=tex2Dlod(LightSampler,LightProj).x;
	LightProj.xy=IN.ShadowMask.yz+LightProj.xy*IN.ShadowMask.w;
	return IN.LightMask*SpotImage*step(Attenuation/IN.LightPos.w,tex2Dlod(ShadowMapSampler,LightProj)[IN.ShadowMask.x]);
     }

//--------------
// techniques   
//--------------
    technique WorldPosFromDepth
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS(); 
 	PixelShader  = compile ps_3_0 PS();
	AlphaBlendEnable=true;
	SrcBlend=one;
 	DestBlend=one;
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }